% ALPHA ENGINE DEFINITION
% Generated 17-Mar-2023 11:09:26

% SUGGESTED CITATION:
% Geely 1.5L Miller GHE from 2020 Aachen Paper - ALPHA Map Package. Version 2023-03. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2023.


% Constructor
engine = class_REVS_engine();
engine.name =  'Geely 1.5L Miller GHE from 2020 Aachen Paper'; 
engine.source_filename = mfilename;
engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  1.5; 
engine.num_cylinders =  3; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.compression_ratio =  13.1; 
engine.bore_mm =  82.547; 
engine.stroke_mm =  93.428; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	     0.0000000000000000	;     120.23611956317013	;     141.72031645273225	;     159.43535603550373	;     166.21983920867083	;     197.12692952228917	;     216.72654781081587	;     260.82568885528110	;     419.50721334565088	;     515.37816025799339	;     569.25613057682210	;     597.71893710566326	;     626.18174363450441		]; 
engine.full_throttle_torque_Nm = [	     0.0000000000000000	;     116.88311700000000	;     127.59740300000000	;     141.55844200000001	;     149.02597399999999	;     167.85714300000001	;     186.03896100000000	;     215.58441600000000	;     215.25973999999999	;     193.31786500000001	;     185.27842200000001	;     158.81007599999998	;     0.0000000000000000		]; 
engine.naturally_aspirated_speed_radps = [	     0.0000000000000000	;     626.18174363450441		]; 
engine.naturally_aspirated_torque_Nm = [	     107.42958658702935	    107.42958658702935		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	     0.0000000000000000	;     36.651914291880921	;     733.03828583761833		]; 
engine.closed_throttle_torque_Nm = [	    -11.963636363636365	;    -11.963636363636365	;    -32.536363636363639		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	     0.0000000000000000	;     36.651914291880921	;     73.303828583761842	;     94.247779607693786	;     119.03471230272291	;     149.40751815315477	;     179.61719043450532	;     197.21060822125199	;     219.40450933440354	;     241.28528007186685	;     247.96195341938025	;     262.89034430469326	;     276.08122155294552	;     284.62261651665767	;     310.44676094752549	;     340.48033105533057	;     362.67571112293456	;     374.36187437335548	;     380.52813888013873	;     386.30771942890135	;     391.42341331928770	;     407.04175405884587	;     424.32834434076949	;     445.89967114647391	;     467.76672154849598	;     477.02487544932353	;     498.95594142963409	;     520.59455493034034	;     542.85389790284694	;     571.08424844850731	;     598.63299604150586	;     626.18174363450441		]; 
engine.fuel_map_torque_Nm = [	    -34.163181818181819	;    -12.081590909090909	;     10.000000000000000	;     25.867257996951214	;     41.734515993902427	;     58.645914049370560	;     75.557312104838701	;     83.233201552419345	;     90.909090999999989	;     96.844548000000003	;     102.14327137500001	;     108.05104400000000	;     111.46171657894735	;     119.71913539473684	;     131.84962312499999	;     139.19373566666667	;     145.04060316666667	;     152.16836799999999	;     160.77665408333334	;     167.37238950000000	;     170.66125299999999	;     173.82830600000000	;     177.48259862499998	;     179.67517450000000	;     188.39617173809523	;     196.24129900000000	;     199.04292350000000	;     202.33178699999999	;     204.84918749999997	;     210.50319012500000	;     218.43341346250003	;     226.36363680000002		]; 
engine.fuel_map_gps = [
  0.026025418117232121	 -0.018254896245911048	 -0.061248309544557206	 -0.084707786747212674	  -0.11132705593594702	  -0.14105446510699543	  -0.16568618646690980	  -0.17771244147984108	  -0.19062739686264676	  -0.20036356547190481	  -0.20292935498288212	  -0.20814420861763061	  -0.21197392175136526	  -0.21415834551755994	  -0.21857476517649785	  -0.21754920819759391	  -0.21326530282286024	  -0.21030856209087506	  -0.20865236179077593	  -0.20706128117624648	  -0.20562558982744322	  -0.20095153059119159	  -0.19507219368147460	  -0.18671281747089419	  -0.17726422280080512	  -0.17311801472507143	  -0.16300758757400363	  -0.15269701313945289	  -0.14191149668955230	  -0.12812117684862556	  -0.11466568792447134	  -0.10123429952780176	;
  0.085343644273055366	  0.070581413968760845	  0.057300695680509085	  0.051682259091352885	  0.047362229380610396	  0.047582198050986436	  0.055262542959224170	  0.062489044475393066	  0.074026286243287984	  0.088407189888206103	  0.093201892693458369	   0.10445362102511736	   0.11523279860140394	   0.12254885116295135	   0.14724376441970927	   0.18379385403287421	   0.21520755268856759	   0.23254983338888136	   0.24180262773707575	   0.25051436610417138	   0.25825168895868733	   0.28213962540443288	   0.30911583518978730	   0.34336194651825241	   0.37835570116785905	   0.39315286382885056	   0.42810286278926341	   0.46222488766009256	   0.49687565148369806	   0.54010356269719673	   0.58169445053833380	   0.62303566237891361	;
   0.11279634375575781	   0.14536340193293298	   0.16942635338482140	   0.17410012905989883	   0.19446251551402483	   0.23628368181781922	   0.28762024116200768	   0.31849421872792327	   0.35746399090747205	   0.39525712577264965	   0.40669755224189719	   0.43218848437070306	   0.45479554315832638	   0.46958970814913281	   0.51638801340582552	   0.58843828800413256	   0.64747151834462457	   0.67889413141195687	   0.69547136264552167	   0.71099949669730012	   0.72473334086312569	   0.76652895791732978	   0.81240846001894007	   0.86915290815801438	   0.92640256325511583	   0.95066052043461302	    1.0082282065640713	    1.0653766930840034	    1.1245347044722178	    1.2000977423665389	    1.2744568736846926	    1.3491753663481898	;
  0.079245072651963566	   0.14972674531927085	   0.22206109039741512	   0.26593644263324945	   0.32037863483152357	   0.39202585493798092	   0.46819754275078035	   0.51369745076649431	   0.57181391752224231	   0.62958154161624891	   0.64726778293604526	   0.68690947092034749	   0.72222327576911083	   0.74524417243744290	   0.81614008015972561	   0.90354321429917928	   0.97111494748057103	    1.0072131183344240	    1.0263250087851992	    1.0442632017333164	    1.0601579582448504	    1.1088616728299083	    1.1631793718497099	    1.2315560470859415	    1.3016790723348388	    1.3316365236525418	    1.4033997598338510	    1.4767139960098541	    1.5556998113811418	    1.6623210773247070	    1.7717147571682408	    1.8832219120569516	;
  0.046302063372860414	   0.15607448504226543	   0.27071906020809383	   0.34056554445991416	   0.42317680897569293	   0.52361744116412767	   0.62590797346594840	   0.68718031277102487	   0.76551625670272072	   0.84179714567439068	   0.86487086528300183	   0.91618101277013198	   0.96167021098996552	   0.99130011777233873	    1.0816489781999177	    1.1883662601469940	    1.2687298255971058	    1.3111020268250790	    1.3334311990680205	    1.3543323535394718	    1.3728518593121644	    1.4297675603863975	    1.4944543153575436	    1.5772439765172528	    1.6617183311223243	    1.6976573390185092	    1.7828978456740290	    1.8675123239009022	    1.9637965435400944	    2.1170160469726342	    2.2716221863310859	    2.4240726539223805	;
  0.041032188417884793	   0.18034725942397092	   0.31931576766649167	   0.39818591169706180	   0.49100274497743074	   0.60556476671743475	   0.72656086560581001	   0.79919454469465723	   0.89262753748148527	   0.98743331476375329	    1.0166590774011035	    1.0823071333010597	    1.1404618326068952	    1.1780789179270876	    1.2913357037351814	    1.4215964199745008	    1.5185362661178246	    1.5701110163931049	    1.5974343389620858	    1.6230971195078154	    1.6458555665537211	    1.7158593239753370	    1.7950976747258836	    1.8976287674260843	    2.0071745799704330	    2.0549945243757923	    2.1718698643792176	    2.2947159248115208	    2.4299023345047099	    2.6148288908398127	    2.7876011361607249	    2.9565290222750562	;
  0.059108548356802314	   0.21888684921359805	   0.37789894874487834	   0.46792307527754512	   0.57363196464709409	   0.70313402614460652	   0.84130404384228408	   0.92433707243277852	    1.0315795039917817	    1.1424133979325493	    1.1769004044231859	    1.2547015520230325	    1.3238300517943271	    1.3684880043911842	    1.5028118594318047	    1.6528912307072108	    1.7653762045318460	    1.8263000909003815	    1.8585793180167469	    1.8888803096722906	    1.9157327068136609	    1.9982565838914166	    2.0926719937795193	    2.2165304047414005	    2.3490262340997821	    2.4064880883498772	    2.5457366655469764	    2.6886881818945216	    2.8408986956911941	    3.0408066804249385	    3.2401862878335264	    3.4409956185988801	;
  0.071600008348051802	   0.24046644502841782	   0.40934691153619024	   0.50586073903461093	   0.61998812645399648	   0.76135665884851444	   0.90841451209806789	   0.99697346308451495	    1.1114968679209665	    1.2280726363309868	    1.2640576753247539	    1.3449911152966807	    1.4169519310690408	    1.4636312980921256	    1.6050605654640755	    1.7689395142158759	    1.8921659029961400	    1.9579580563830223	    1.9927620056094852	    2.0254185794943327	    2.0543499354500656	    2.1431307390658767	    2.2443935077480845	    2.3767232670885496	    2.5173925931336747	    2.5780600102914475	    2.7243563422435075	    2.8746163402278930	    3.0352690283461481	    3.2470711115293343	    3.4593508683432765	    3.6737119058157410	;
  0.085807374267137415	   0.26406377548180426	   0.44303812286198258	   0.54603657807973349	   0.66878624355159411	   0.82185686777443467	   0.97932270821452916	    1.0735623583873295	    1.1948307277317343	    1.3172372843190097	    1.3549149367430251	    1.4395541484973624	    1.5148431446753459	    1.5637598062793854	    1.7128169999437659	    1.8896588552845859	    2.0232991133454683	    2.0945042043329329	    2.1322203754122819	    2.1676381808725314	    2.1990418735893473	    2.2955715475219534	    2.4046853597880808	    2.5452421540400305	    2.6930319817114237	    2.7565151633575686	    2.9091405320962322	    3.0670742307634309	    3.2376878777797633	    3.4626513974872655	    3.6874829704305379	    3.9141131340214654	;
  0.097860494074836615	   0.28379467349709109	   0.47082124344044479	   0.57884500270907413	   0.70799070955269816	   0.86952860062383530	    1.0352979057280334	    1.1340458262573148	    1.2606419517132863	    1.3879191048503570	    1.4270726060531691	    1.5150190114418514	    1.5933213599910336	    1.6442501139915982	    1.7999361875826150	    1.9862752422572700	    2.1276022003158896	    2.2029726595704457	    2.2429029579439503	    2.2804017552060141	    2.3136500990313231	    2.4158196995630501	    2.5309727023398585	    2.6785349517355987	    2.8330188614417997	    2.8994266580497010	    3.0592548644105699	    3.2241164454757172	    3.4026359715247789	    3.6373150635558469	    3.8706437109687251	    4.1048768551325239	;
   0.10920668736095028	   0.30236778986399399	   0.49677568527568028	   0.60921418744394684	   0.74379953108731556	   0.91244826120512001	    1.0856064523827922	    1.1885058185095148	    1.3201069346678094	    1.4520056949415898	    1.4925606403897065	    1.5836547585136695	    1.6648711040686248	    1.7177600206953543	    1.8799166157392735	    2.0745321873515752	    2.2223894477970161	    2.3012957859426950	    2.3431031142154430	    2.3823649747350393	    2.4171758669387922	    2.5241318410253752	    2.6445933723216917	    2.7988266142181257	    2.9604891529720958	    3.0301810084211596	    3.1983804450432105	    3.3711125380119156	    3.5558222716741779	    3.7987409218573789	    4.0383675368413163	    4.2776499349040185	;
   0.12233319211672443	   0.32408496099433776	   0.52701106285017918	   0.64428125344374010	   0.78459909569619768	   0.96056045490161235	    1.1418200305051038	    1.2495473788203633	    1.3870894531758373	    1.5245169683971422	    1.5667047834606411	    1.6614135026216796	    1.7460668801732897	    1.8013311185095726	    1.9713622013385614	    2.1748684501348907	    2.3295841062048801	    2.4122224675574646	    2.4560175142748260	    2.4971501370646294	    2.5336225124404224	    2.6457138302953980	    2.7720607046415267	    2.9341110544466193	    3.1046033048434603	    3.1782774166900749	    3.3564117161233189	    3.5389146779061798	    3.7324624059766078	    3.9848425393961793	    4.2293753181969027	    4.4722526465920751	;
   0.12996716962909449	   0.33694073703314764	   0.54495628462407752	   0.66501809283898472	   0.80854881017929858	   0.98844299212928033	    1.1742357414908178	    1.2848347413931434	    1.4258906120774115	    1.5667048595145903	    1.6098894217219037	    1.7068144114198458	    1.7935415781509145	    1.8502277107392511	    2.0248376219155930	    2.2332818048226093	    2.3918568400962599	    2.4766068214412069	    2.5215294594106230	    2.5637247943631873	    2.6011422039653351	    2.7161684497585821	    2.8459177320307929	    3.0125360143425937	    3.1881606919202157	    3.2641173186878176	    3.4478865851047908	    3.6361514166923126	    3.8357713119580095	    4.0940269637366864	    4.3404929683469691	    4.5850919236761962	;
   0.14824970500133558	   0.36894963746961923	   0.59008840433635035	   0.71707067923165757	   0.86823806929411851	    1.0567199511285379	    1.2526149487547324	    1.3701036757954346	    1.5198238473771286	    1.6692936762711081	    1.7152346202860087	    1.8184356176990237	    1.9105635186107419	    1.9706241245041995	    2.1551842506489081	    2.3756307761696247	    2.5435929542822957	    2.6333994207378510	    2.6810341797445387	    2.7257892021886567	    2.7654848945059429	    2.8876100648224159	    3.0256365356752957	    3.2033475170239480	    3.3911187391878519	    3.4723720599692962	    3.6690302059507922	    3.8706387939383458	    4.0843255848980338	    4.3585116639879971	    4.6105706205829335	    4.8600175050468168	;
   0.16861365516486729	   0.41501762198321684	   0.66067344006902340	   0.80058782117675442	   0.96601543200536888	    1.1698089057544601	    1.3781204020228550	    1.5021248170488533	    1.6612070841229687	    1.8217926922434686	    1.8712453940760265	    1.9823707807664266	    2.0813043662260369	    2.1456516296810011	    2.3425321383724591	    2.5817215264161275	    2.7654469001492963	    2.8637581588328147	    2.9158842576692310	    2.9648445826049685	    3.0082578950887373	    3.1417033210569785	    3.2923874788530676	    3.4859134152542484	    3.6888480208099343	    3.7761425672208815	    3.9861131378752379	    4.1989738320731105	    4.4228697554111811	    4.7118918837761852	    4.9944166732618687	    5.2766167503326615	;
   0.17242648659414281	   0.43762054758953978	   0.70178364512507807	   0.85189666421902399	    1.0288578316961272	    1.2448535272447627	    1.4602711994603699	    1.5860667678174776	    1.7472832034287469	    1.9121519157518194	    1.9633943818173223	    2.0791489784875616	    2.1829060825304314	    2.2505272009356769	    2.4577851272367153	    2.7064493849325286	    2.8980797185099481	    3.0014738263833922	    3.0564302415570435	    3.1081099142535660	    3.1539760454657317	    3.2953241215346996	    3.4550381683629783	    3.6584395478945551	    3.8689252023358098	    3.9592345073234503	    4.1762908613635323	    4.3973549166479708	    4.6315857111806515	    4.9374814901348669	    5.2414600971229062	    5.5470707780393509	;
   0.17140703311165131	   0.45259402392584719	   0.73269086793700300	   0.89171906907197529	    1.0788363199096189	    1.3054472933493193	    1.5267147170219009	    1.6544858882007130	    1.8168140957621133	    1.9831141670736208	    2.0353072060503208	    2.1540065531803947	    2.2619225052269596	    2.3327739646296632	    2.5526117874447292	    2.8063255427596299	    3.0027611819837379	    3.1099694921134988	    3.1671909485016267	    3.2211080084092933	    3.2690386235246121	    3.4175364635615080	    3.5859186621957884	    3.7967175938545470	    4.0121931105956712	    4.1048487982928705	    4.3284428672643189	    4.5583032472000884	    4.8036149638700794	    5.1259494144637978	    5.4476704950518284	    5.7717234923924066	;
   0.16468332546530356	   0.46631782498186880	   0.76690783343555169	   0.93752181555323622	    1.1380061342737315	    1.3793404835146090	    1.6110290711127244	    1.7423307771884493	    1.9056087826245043	    2.0705866909219086	    2.1227613035936121	    2.2423222741328592	    2.3540115890942772	    2.4288688608483744	    2.6714059815428866	    2.9281009210361764	    3.1304173849611749	    3.2419249275925721	    3.3015925557437793	    3.3578756942331127	    3.4079529387210163	    3.5635580458999572	    3.7410268007531298	    3.9636761946818089	    4.1865071446175932	    4.2829769144514183	    4.5179517541822740	    4.7626394015138631	    5.0250654743338803	    5.3698673384926421	    5.7130370483212491	    6.0581816577525087	;
   0.14574484495947326	   0.47304089458536336	   0.79937362484708219	   0.98469890918458802	    1.2025394980817872	    1.4647793150252315	    1.7157758123107161	    1.8561011059161396	    2.0254463449222224	    2.1889768674146697	    2.2395942706885368	    2.3543605705905093	    2.4616215211297883	    2.5353643413571088	    2.7808959670761291	    3.0725082674124460	    3.2921379801275368	    3.4095363840904738	    3.4718045715308188	    3.5303165025560053	    3.5822250408821223	    3.7420766179196763	    3.9233326980088119	    4.1573333717204743	    4.4007339556920542	    4.5069851632477409	    4.7674871295461596	    5.0378023205164553	    5.3246089268804324	    5.6960947446412069	    6.0614024228003744	    6.4270349303017325	;
   0.12291891321655427	   0.46998937450255474	   0.81612254210279889	    1.0128022886332388	    1.2441476308843125	    1.5231098960236822	    1.7906189914418051	    1.9401802985609182	    2.1218413250184440	    2.2961350700674430	    2.3497935495302129	    2.4709243116201427	    2.5820892212811777	    2.6568948602315579	    2.8998474708961202	    3.2041917912416316	    3.4353331493145833	    3.5578742849331664	    3.6226328555269740	    3.6833716967207408	    3.7371681202566158	    3.9018841896981842	    4.0868277126469383	    4.3263054408292207	    4.5909539575566880	    4.7079750470470305	    4.9934511164507658	    5.2830630538298795	    5.5852753648334392	    5.9714444242319145	    6.3481288332991435	    6.7243708789702685	;
   0.10974458851225538	   0.46662590319524555	   0.82257709993917760	    1.0248838970045313	    1.2629206471397891	    1.5502309699186969	    1.8265285537422002	    1.9816719883067730	    2.1711661022580730	    2.3523311735901915	    2.4080184900964952	    2.5335796968848214	    2.6480444605587103	    2.7240529198903198	    2.9678968649823405	    3.2769480361518641	    3.5130572465756842	    3.6383768653268804	    3.7046199920673679	    3.7667576017480373	    3.8217975650972145	    3.9903742063540424	    4.1798314443529545	    4.4257058385388852	    4.7006952202223315	    4.8221423182993979	    5.1172595094912419	    5.4144103499801410	    5.7224819137254190	    6.1138958395697927	    6.4948945773258320	    6.8754109130935293	;
  0.096324269818672037	   0.46262163978979820	   0.82799526280974789	    1.0357020268748278	    1.2801606351134596	    1.5755122577239085	    1.8605044599911962	    2.0214540420530605	    2.2191114933638674	    2.4072222706754842	    2.4649128916900906	    2.5947588028117199	    2.7124082543533796	    2.7900673300981325	    3.0366385872717299	    3.3502634885117883	    3.5909010511033288	    3.7189811519330727	    3.7867610684911401	    3.8503781164642286	    3.9067589261815145	    4.0797832944456811	    4.2750281371509642	    4.5294793833708100	    4.8137304647824450	    4.9386533864107323	    5.2414647492576059	    5.5448468405018314	    5.8576139436380767	    6.2530356480837996	    6.6376793186642828	    7.0219472883599492	;
  0.079909862529270043	   0.45702194044432776	   0.83322062918129147	    1.0471353034789195	    1.2989841827148481	    1.6036392051046664	    1.8988980463553673	    2.0668279922693693	    2.2742817917797207	    2.4709230656977859	    2.5308656759277137	    2.6654336637367231	    2.7869314293257168	    2.8669361454828541	    3.1193750996920224	    3.4392244490111756	    3.6849724781855255	    3.8163370842425874	    3.8860160607180863	    3.9515014238045434	    4.0096100200401832	    4.1887474994051104	    4.3925121352571539	    4.6596792545432457	    4.9531902277963882	    5.0812244423682182	    5.3911852246492060	    5.7005274670587296	    6.0173218166564970	    6.4158278563681250	    6.8041753586174361	    7.1923907646672358	;
  0.069666243703012526	   0.45324232666653169	   0.83591492638229570	    1.0535472670449908	    1.3098297676833526	    1.6200926086281331	    1.9215655144485078	    2.0936783568787907	    2.3069918312753184	    2.5089527704563612	    2.5701799236949805	    2.7075666753050878	    2.8315523519818711	    2.9131567869324608	    3.1702004856553985	    3.4944748121375957	    3.7433969803364664	    3.8768049654177736	    3.9476754953696198	    4.0143458568143142	    4.0735601263276724	    4.2567099238101953	    4.4660145651912497	    4.7408781669258095	    5.0397609564196983	    5.1696384140993565	    5.4835703377928953	    5.7961081455980601	    6.1146889591307199	    6.5143357081016919	    6.9047860547377322	    7.2952449013462788	;
  0.023625259122257259	   0.43255984787095142	   0.84070214328650328	    1.0730538881633318	    1.3470246998614808	    1.6800298858375036	    2.0066962932928676	    2.1946847191106853	    2.4289043522330354	    2.6531185348093884	    2.7205282029044615	    2.8710601504883160	    3.0078891727568524	    3.0985224769275375	    3.3867661502038446	    3.7381357860420077	    4.0026021497707767	    4.1463481096287680	    4.2232486024809530	    4.2958340027429491	    4.3604690413211937	    4.5620002518160394	    4.7945921978361943	    5.0979724037091394	    5.4175934868814073	    5.5546205351932798	    5.8820711856460512	    6.2033593991372413	    6.5214602740978185	    6.9168985360757107	    7.3144313363231328	    7.7124155715130289	;
-0.0080617890067976247	   0.40418922745033387	   0.83486713507356081	    1.0805513907991411	    1.3708386782259039	    1.7252626134169156	    2.0754389282002195	    2.2780474038400134	    2.5321934226658609	    2.7811547578799805	    2.8572398364989118	    3.0279157105662557	    3.1819998129605378	    3.2834530052345503	    3.6006280477494736	    3.9846096995181464	    4.2768772067130483	    4.4342756868845949	    4.5179937329385416	    4.5967709156633569	    4.6667420100288401	    4.8831317542401607	    5.1303287236355324	    5.4502758722953697	    5.7827954025981745	    5.9233149001520582	    6.2549306791291786	    6.5775688626089801	    6.9010395772564870	    7.3058517941109899	    7.7039905342005151	    8.1037215152093651	;
 -0.013782744150259095	   0.39875393934167386	   0.83162050077086425	    1.0820887123596641	    1.3782728763607885	    1.7405488832276608	    2.0996656856451521	    2.3081545449863907	    2.5706477696815506	    2.8298140892446142	    2.9093570854534665	    3.0881185755894682	    3.2488442585517494	    3.3542110770895630	    3.6819123902114321	    4.0787474460513389	    4.3801861770182438	    4.5416827829293389	    4.6274085073813280	    4.7079967144322143	    4.7795186110016541	    5.0001029602013300	    5.2510416049475896	    5.5752119299738263	    5.9117379748677941	    6.0530383242948158	    6.3859181487056702	    6.7096411847801258	    7.0361377395443334	    7.4449253355758076	    7.8446975981872180	    8.2456451437371108	;
 -0.020604562977245239	   0.39931513435609645	   0.82741090823336727	    1.0835046035667768	    1.3866405580077992	    1.7582271308176394	    2.1281006022960294	    2.3437857386941059	    2.6165726950944035	    2.8881115155605777	    2.9717205635722928	    3.1598180739590132	    3.3283733571123610	    3.4385317970856311	    3.7791655859052611	    4.1915043851466516	    4.5033552362932410	    4.6692873737499836	    4.7571645816949459	    4.8396872200409984	    4.9128623187978295	    5.1378839203027127	    5.3926014269684321	    5.7210004343998930	    6.0613568358897112	    6.2038572714428311	    6.5388786882364478	    6.8645012593545207	    7.1945386993527736	    7.6080064318311464	    8.0102822576872175	    8.4130197837052609	;
 -0.025888442493208100	   0.39967630452166220	   0.82532065423740120	    1.0843590900267435	    1.3928391753483218	    1.7716301258072542	    2.1499448525923235	    2.3713382412077864	    2.6522906697725794	    2.9334113403858280	    3.0200976647670350	    3.2151932636583558	    3.3897339734333740	    3.5036329354141191	    3.8546264838196884	    4.2790625917932186	    4.5987502295037652	    4.7678083337258181	    4.8571831495643405	    4.9410511446953311	    5.0153781680780645	    5.2435124441287275	    5.5007621638421487	    5.8319607106062081	    6.1745880627167571	    6.3183876831901244	    6.6555307070785874	    6.9829782647440037	    7.3156650966177796	    7.7326563970641224	    8.1371772487815441	    8.5415848318924326	;
 -0.037994268454518587	   0.40022399629408884	   0.83867309487423358	    1.0894517683690839	    1.4059897279917648	    1.8013352183879074	    2.1995346505697317	    2.4345321426042497	    2.7348029411218007	    3.0375716535390853	    3.1310242317800352	    3.3413691351138870	    3.5292794352018246	    3.6517239380127977	    4.0275833244334169	    4.4797895047704364	    4.8168660773666314	    4.9919405225109958	    5.0840909862672277	    5.1704953378285001	    5.2470329310434218	    5.4814384826045908	    5.7439198091767674	    6.0808189376956534	    6.4274638746506652	    6.5733793367308007	    6.9160263789794625	    7.2487397427604439	    7.5872282930116777	    8.0118788518188921	    8.4225666058446542	    8.8320247604926951	;
 -0.055579929976541272	   0.40031199615715019	   0.85668709755439965	    1.1179899462878586	    1.4278490637709456	    1.8426041656086070	    2.2714764401086929	    2.5272092349781379	    2.8560307591656731	    3.1889479470698379	    3.2917137721753251	    3.5229890901052205	    3.7294626188780549	    3.8639060508506153	    4.2755268864146290	    4.7634512482944702	    5.1207745725298714	    5.3055716042894288	    5.4026950438287038	    5.4936492680283591	    5.5741314908011566	    5.8197910000419126	    6.0925730417445649	    6.4353339512631864	    6.7842218090359161	    6.9316298397104710	    7.2796174997611267	    7.6196928226250105	    7.9663772917453279	    8.4018367488115135	    8.8232935342821275	    9.2432191262526828	;
 -0.073479269838526443	   0.40003923540733588	   0.87431927300030754	    1.1461826968731075	    1.4689471133360159	    1.8841067188434866	    2.3450998595767207	    2.6221420186697220	    2.9798536261905295	    3.3428784092175783	    3.4549260941900992	    3.7070246767174622	    3.9317984074061032	    4.0779671064895409	    4.5236421394331092	    5.0430325699331107	    5.4196094072612553	    5.6153792820000668	    5.7182818785644995	    5.8145650933946555	    5.8996694941012064	    6.1582401167674430	    6.4415979679561994	    6.7915299364887964	    7.1435144126094992	    7.2922483259559634	    7.6440234837445731	    7.9899663865821404	    8.3443048145829621	    8.7909149701300802	    9.2241025529137275	    9.6560342619411124	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel;
engine.fuel.description =  'Fuel info was derived from 3-cyl Geely 1.5L DHE paper'; 
engine.fuel.density_kgpL_15C =  0.74008883199999997; 
engine.fuel.energy_density_MJpkg =  42.78; 
engine.fuel.research_octane_number =  98; 

% Idle Speed
engine.idle_target_speed_radps = class_REVS_dynamic_lookup;
engine.idle_target_speed_radps.axis_1.signal =  'eng_runtime_sec'; 
engine.idle_target_speed_radps.axis_1.breakpoints = [	     0.0000000000000000	    10.000000000000000		]; 
engine.idle_target_speed_radps.table = [	     68.067840827778852	    68.067840827778852		]; 

% Calibration Adjustment Factors
engine.variant =  'basic engine'; 
